#include <iostream>
#include <cassert>
#include <cstdlib>
#include <cmath>
#include <string>
#include "Length.hpp"
using namespace std;
using namespace Units;

static void assert_eql (double x, double y)
{
  const double EPSILON = 0.1;
  assert (abs (x - y) < EPSILON);
}

static void assert_eql (Length x, Length y)
{
  assert_eql (x/YARD, y/YARD);
}

template <typename T>
inline void println (const T&x) { cout << x << endl; }

struct S { S (Length) {} };

void f (S) {}

int
main (int argc, char *argv[])
{
  Length x = 3.0 * METER; // as efficient as: double x = 3.0;
  Length y = 4.0 * YARD;
  Length z = x + y;

  assert_eql (x / METER, 3.0);
  assert_eql (3.14 * METER, METER * 3.14);

  {
    Length xx = x;
    assert_eql (x/YARD, xx/YARD);
    xx = 2 * xx;
    assert_eql (2 * x/METER, xx/METER);
  }

  assert_eql (y / YARD, 4.0);

  assert_eql (METER/YARD, 1.0/.914);

  assert_eql (z, x+y);
  assert_eql (z/YARD, x/YARD + y/YARD);

  {
    double e = x / YARD;
    assert_eql (e, (x/METER) / (YARD/METER));
  }

  //Length zz = x * y;           // COMPILE ERROR
  //double d = x;                // COMPILE ERROR

  assert (& x);
  //assert (& METER); // COMPILE ERROR

  f (1.0 * METER);  // OK
  // f (METER);     // COMPILE ERROR
  // METER = METER; // COMPILE ERROR

  return 0;
}
