#include <iostream>
#include <cassert>
#include <cstdlib>
#include <cmath>
#include <string>
#include "Units.hpp"
using namespace std;
using namespace Units;

static void assert_eql (double x, double y)
{
  const double EPSILON = 0.1;
  assert (abs (x - y) < EPSILON);
}

static void assert_eql (Length x, Length y)
{
  assert_eql (x/FOOT, y/FOOT);
}

static void assert_eql (Area x, Area y)
{
  assert_eql (x/HECTARE, y/HECTARE);
}

template <typename T>
inline void println (const T&x) { cout << x << endl; }

struct S { S (Length) {} };
void f (S) {}

int
main (int argc, char *argv[])
{
  Length x = 3.0 * METER; // as efficient as: double x = 3.0;
  assert_eql (x / METER, 3.0);
  assert_eql (3.14 * METER, METER * 3.14);

  {
    Length xx = x;
    assert_eql (x/FOOT, xx/FOOT);
    xx = 2 * xx;
    assert_eql (2 * x/INCH, xx/INCH);
  }

  Length y = 4.0 * FOOT;
  assert_eql (y / FOOT, 4.0);

  assert_eql (METER/FOOT, 1.0/.304);

  Length z = x + y;
  assert_eql (z, x+y);
  assert_eql (z/FOOT, x/FOOT + y/FOOT);

  //Length z = x * y;            // COMPILE ERROR

  Area   a = x * y;
  assert_eql (a, x*y);
  assert_eql (a / SQUARE_METER, (x/METER) * (y/METER));

  //double d = x;                // COMPILE ERROR

  double e = x / YARD;
  assert_eql (e, (x/METER) / (YARD/METER));

  //double f = a / METER; // COMPILE ERROR

  Length n = a / METER;
  assert_eql (n / METER, a / SQUARE_METER);

  assert_eql (SQUARE_FOOT/HECTARE, square(FOOT)/HECTARE);

  double g = a / SQUARE_FOOT;
  double h = a / SQUARE_METER;
  assert_eql (g / h, SQUARE_METER / SQUARE_FOOT);

  assert_eql (FOOT/INCH, 12.0);
  assert_eql (SQUARE_FOOT, FOOT*FOOT);
  assert_eql (SQUARE_METER, METER*METER);

  f (1.0 * METER);  // OK
  f (METER);        // OK!!
  //METER = METER; // COMPILE ERROR

  return 0;
}
