#ifndef UNITS_HPP_
#define UNITS_HPP_

namespace Units
{
  template <typename T> class Literal_ : private T
  {
  protected:
    Literal_ () {}
  private:
    void operator& ();
    Literal_ (const Literal_&);
    void operator= (const Literal_&);
  };

  class Length
  {
  private:
    double meters_;
    Length (double meters) : meters_ (meters) {}

    Length () : meters_ (99.44 /* unused */) {}
    friend class Literal_<Length>;

  public:
    class Meter_;
    class Foot_;
    class Yard_;
    class Inch_;

    Length (const Meter_&) : meters_ (1.000) {}
    Length (const Foot_ &) : meters_ (0.304) {}
    Length (const Yard_ &) : meters_ (0.914) {}
    Length (const Inch_ &) : meters_ (.0254) {}

    friend inline Length operator* (double d, Length x)
    { return Length (d * x.meters_); }

    friend inline Length operator* (Length x, double d)
    { return Length (x.meters_ * d); }

    friend inline Length operator+ (Length x, Length y)
    { return Length (x.meters_ + y.meters_); }

    friend inline double operator/ (Length x, Length y)
    { return x.meters_ / y.meters_; }

    friend inline Length operator/ (Length x, double y)
    { return Length (x.meters_ / y); }
  };

  class Length::Meter_ : public Literal_<Length> {};
  class Length::Foot_  : public Literal_<Length> {};
  class Length::Yard_  : public Literal_<Length> {};
  class Length::Inch_  : public Literal_<Length> {};

  extern Length::Meter_ METER;
  extern Length::Foot_  FOOT;
  extern Length::Yard_  YARD;
  extern Length::Inch_  INCH;

  class Area
  {
  private:
    double square_meters_;
    Area (double square_meters) : square_meters_ (square_meters) {}

    Area () : square_meters_ (99.44 /* unused */) {}
    friend class Literal_<Area>;

  public:
    class Square_Meter_;
    class Square_Foot_;
    class Hectare_;

    Area (const Square_Meter_&) : square_meters_ (1.000)  {}
    Area (const Square_Foot_ &) : square_meters_ (0.0929) {}
    Area (const Hectare_     &) : square_meters_ (10000)  {}

    friend inline Area operator* (Area x, double d)
    { return Area (x.square_meters_ * d); }

    friend inline Area operator* (double d, Area x)
    { return Area (d * x.square_meters_); }

    friend inline Area operator* (Length x, Length y)
    { return Area ((x / METER) * (y / METER)); }

    friend inline Length operator/ (Area x, Length y)
    { return (x.square_meters_ /  (y / METER)) * METER; }

    friend inline double operator/ (Area x, Area y)
    { return (x.square_meters_ /  y.square_meters_); }

    friend inline Area square (Length x)
    { return x * x; }
  };

  class Area::Square_Meter_ : public Literal_<Area> {};
  class Area::Square_Foot_  : public Literal_<Area> {};
  class Area::Hectare_      : public Literal_<Area> {};

  extern Area::Square_Meter_ SQUARE_METER;
  extern Area::Square_Foot_  SQUARE_FOOT;
  extern Area::Hectare_      HECTARE;

} // namespace Units

#endif /* recursive inclusion guard */
