#ifndef LENGTH_HPP_
#define LENGTH_HPP_

namespace Units
{
  class Length
  {
  private:
    double meters_;
    Length (double meters) : meters_ (meters) {}

  public:
    friend inline Length METER () { return Length (1.000); }
    friend inline Length YARD  () { return Length (0.914); }

    friend inline Length operator* (double d, Length x)
    { return Length (d * x.meters_); }

    friend inline Length operator* (Length x, double d)
    { return Length (x.meters_ * d); }

    friend inline Length operator+ (Length x, Length y)
    { return Length (x.meters_ + y.meters_); }

    friend inline double operator/ (Length x, Length y)
    { return x.meters_ / y.meters_; }

    friend inline Length operator/ (Length x, double y)
    { return Length (x.meters_ / y); }
  };
} // namespace Units

// Avert thine eyes...
#define METER METER()
#define YARD  YARD()

#endif /* recursive inclusion guard */
