#include <iostream>
#include <cassert>
#include <cstdlib>
#include <cmath>
#include <string>
#include "Length.hpp"
using namespace std;
using namespace Units;

static void assert_eql (double x, double y)
{
  const double EPSILON = 0.1;
  assert (abs (x - y) < EPSILON);
}

static void assert_eql (Length x, Length y)
{
  assert_eql (x/Length::yards(1.0), y/Length::yards(1.0));
}

template <typename T>
inline void println (const T&x) { cout << x << endl; }

struct S { S (Length) {} };

void f (S) {}

int
main (int argc, char *argv[])
{
  Length x = Length::meters(3.0); // as efficient as: double x = 3.0;
  Length y = Length::yards (4.0);
  Length z = x + y;

  assert_eql (x / Length::meters(1.0), 3.0);

  {
    Length xx = x;
    assert_eql (x, xx);
    xx = 2 * xx;
    assert_eql (2 * x, xx);
  }

  assert_eql (y / Length::yards(1.0), 4.0);

  assert_eql (Length::meters(1.0)/Length::yards(1.0), 1.0/0.914);

  assert_eql (z, x+y);
  assert_eql (z/Length::yards(1.0), x/Length::yards(1.0) + y/Length::yards(1.0));

  {
    double e = x / Length::yards(1.0);
    assert_eql (e, (x/Length::meters(1.0)) / (Length::yards(1.0)/Length::meters(1.0)));
  }

  //Length zz = x * y;           // COMPILE ERROR
  //double d = x;                // COMPILE ERROR

  assert (& x);
  //assert (& Length::meters(1.0)); // Warning: Taking address of temporary

  f (Length::meters(1.0));  // OK

  return 0;
}
