#ifndef LENGTH_HPP_
#define LENGTH_HPP_

namespace Units
{
  class Length
  {
  private:
    double meters_;
    Length (double meters) : meters_ (meters) {}

  public:
    static inline Length meters (double x) { return Length (1.000 * x); }
    static inline Length yards  (double x) { return Length (0.914 * x); }

    friend inline Length operator* (double d, Length x)
    { return Length (d * x.meters_); }

    friend inline Length operator* (Length x, double d)
    { return Length (x.meters_ * d); }

    friend inline Length operator+ (Length x, Length y)
    { return Length (x.meters_ + y.meters_); }

    friend inline double operator/ (Length x, Length y)
    { return x.meters_ / y.meters_; }

    friend inline Length operator/ (Length x, double y)
    { return Length (x.meters_ / y); }
  };
} // namespace Units

#endif /* recursive inclusion guard */
