#ifndef LENGTH_HPP_
#define LENGTH_HPP_

namespace Units
{
  class Length
  {
  private:
    double meters_;
    Length (double meters) : meters_ (meters) {}
    class Literal;

  public:
    class Meter; Length (const Meter&) : meters_ (1.000) {}
    class Yard;  Length (const Yard&)  : meters_ (0.914) {}

    friend inline Length operator* (double d, Length x)
    { return Length (d * x.meters_); }

    friend inline Length operator* (Length x, double d)
    { return Length (x.meters_ * d); }

    friend inline Length operator+ (Length x, Length y)
    { return Length (x.meters_ + y.meters_); }

    friend inline double operator/ (Length x, Length y)
    { return x.meters_ / y.meters_; }

    friend inline Length operator/ (Length x, double y)
    { return Length (x.meters_ / y); }
  };

  class Length::Literal : private Length
  {
  protected:
    Literal () : Length (99.44 /* unused */) {}
  private:
    void operator& ();
    void operator= (const Literal&);
  };

  class Length::Meter : public Literal {}; extern Length::Meter METER;
  class Length::Yard  : public Literal {}; extern Length::Yard  YARD;

} // namespace Units

#endif /* recursive inclusion guard */
