/* Copyright (C) Martin Buchholz 2003 */

package martin;

public class CommandResults
{
    public final String [] argv;
    public final String stdout;
    public final String stderr;
    public final int exitVal;
    public final Exception exception;

    public CommandResults (String [] argv,
			   String stdout,
			   String stderr,
			   int exitVal,
			   Exception exception)
    {
	this.argv = argv;
	this.stdout = stdout;
	this.stderr = stderr;
	this.exitVal = exitVal;
	this.exception = exception;
    }

    public void argvPrint () {
	System.out.print ("argv=");
	for (int j = 0; j < argv.length; ++j)
	    {
		System.out.print ("\"" + argv[j] + "\"");
		if (j != argv.length-1)
		    System.out.print (" ");
	    }
	System.out.print ("\n");
    }

    public void debugPrint () {
	argvPrint ();
	if (exitVal != 0)
	    System.out.print ("exitVal=" + exitVal + "\n");
	if (! stdout.equals (""))
	    System.out.print ("<stdout>\n" + stdout + "</stdout>\n");
	if (! stderr.equals (""))
	    System.out.print ("<stderr>\n" + stderr + "</stderr>\n");
	if (exception != null)
	    exception.printStackTrace();
	System.out.print ("\n");
    }
}
