// Copyright (C) Martin Buchholz 2003

#include <iostream>
#include <cassert>
#include <cstdlib>
#include <string>

using namespace std;

#include "Suit.hpp"
using namespace Cards;


enum Suit_Enum { Suit_Clubs, Suit_Diamonds, Suit_Hearts, Suit_Spades };

inline enum Suit_Enum toEnum (Suit s)
{
  struct Switch : public Suit::Switch
  {
    enum Suit_Enum e;
    void Clubs    () { e = Suit_Clubs;    }
    void Diamonds () { e = Suit_Diamonds; }
    void Hearts   () { e = Suit_Hearts;   }
    void Spades   () { e = Suit_Spades;   }
  } Switch;

  Switch.doit (s);
  return Switch.e;
}

int ordinal (Suit s)
{
  struct Switch : public Suit::Switch
  {
    int ordinal;
    int Ordinal (Suit s)
    {
      doit (s);
      return ordinal;
    }
    void Clubs    () { ordinal = 0; }
    void Diamonds () { ordinal = 1; }
    void Hearts   () { ordinal = 2; }
    void Spades   () { ordinal = 3; }
  } Switch;

  return Switch.Ordinal (s);
}

bool operator< (Suit lhs, Suit rhs)
{
  return ordinal (lhs) < ordinal (rhs);
}


struct ConvertibleFromSuit { ConvertibleFromSuit (Suit) {} };
void f (ConvertibleFromSuit) {}

int
main ()
{
  { Suit s = Suit::spades; assert (s == Suit::spades && s != Suit::clubs); }
  { Suit s (Suit::spades); assert (s == Suit::spades && s != Suit::clubs); }

  {
    Suit s = Suit::spades;
    { Suit t = s; assert (t == s); }
    { Suit t (s); assert (t == s); }
  }

  {
    Suit s = Suit::hearts;
    f (ConvertibleFromSuit (s));
    f (s);
    f (Suit::clubs);
  }

  assert (toString (Suit::clubs)    == "Clubs");
  assert (toString (Suit::diamonds) == "Diamonds");
  assert (toString (Suit::hearts)   == "Hearts");
  assert (toString (Suit::spades)   == "Spades");

  assert (Suit::clubs == Suit::clubs);
  assert (Suit::clubs != Suit::diamonds);

  assert (Suit (Suit::clubs) == Suit (Suit::clubs));
  assert (Suit (Suit::clubs) != Suit (Suit::diamonds));

  assert (Suit::clubs < Suit::diamonds);
  assert (Suit::diamonds < Suit::spades);
  assert (! (Suit::hearts < Suit::diamonds));
  assert (! (Suit::hearts < Suit::hearts));

  // ----------------------------------------------------------------
  //   Suit::spades + 1; // no match for '+' operator

  //   static_cast<int>(Suit::spades); // Invalid static_cast

  // { int x = Suit::clubs; } // cannot convert `const Cards::Suit' to `int'
}
