// Copyright (C) Martin Buchholz 2003

#ifndef _Suit_hpp_INCLUDED
#define _Suit_hpp_INCLUDED

#include <iostream>
#include <string>

namespace Cards
{
  class Suit
  {
  public:
    struct Switch
    {
      virtual void Clubs    () = 0;
      virtual void Diamonds () = 0;
      virtual void Hearts   () = 0;
      virtual void Spades   () = 0;
      void doit (Suit s) { s.visit (*this); }
      virtual ~Switch () {}
    };

  private:
    struct SuitBase
    { virtual void accept (Switch& s) const = 0; };

    struct Clubs: public SuitBase
    { virtual void accept (Switch& s) const { s.Clubs (); } };

    struct Diamonds: public SuitBase
    { virtual void accept (Switch& s) const { s.Diamonds (); } };

    struct Hearts: public SuitBase
    { virtual void accept (Switch& s) const { s.Hearts (); } };

    struct Spades: public SuitBase
    { virtual void accept (Switch& s) const { s.Spades (); } };

  public:
    static const Suit clubs;
    static const Suit diamonds;
    static const Suit hearts;
    static const Suit spades;

    friend bool operator== (Suit x, Suit y) { return x.p == y.p; }
    friend bool operator!= (Suit x, Suit y) { return ! (x == y); }

    inline Suit (const SuitBase *q) : p (q) {}
    inline void visit (Switch& x) const { p->accept(x); }

  private:
    const SuitBase *p;
  };

  inline std::string toString (const Suit& s)
  {
    std::string str;

    struct Switch : public Suit::Switch
    {
      std::string& str;
      Switch (std::string& alias) : str (alias) {}
      void Clubs    () { str = "Clubs";    }
      void Diamonds () { str = "Diamonds"; }
      void Hearts   () { str = "Hearts";   }
      void Spades   () { str = "Spades";   }
    } Switch (str);

    Switch.doit (s);
    return str;
  }

  inline std::ostream& operator<< (std::ostream& o, Suit s)
  {
    return o << toString (s);
  }

}

#endif // Recursive Inclusion Guard
