// Copyright (C) Martin Buchholz 2003

#ifndef _Suit_hpp_INCLUDED
#define _Suit_hpp_INCLUDED

#include <iostream>
#include <string>

namespace Cards
{
  class Suit
  {
  public:
    enum SUIT_ { CLUBS, DIAMONDS, HEARTS, SPADES };

  private:
    SUIT_ S_;

    struct Clubs    {};
    struct Diamonds {};
    struct Hearts   {};
    struct Spades   {};

  public:
    Suit (const Clubs&)    : S_ (CLUBS)    {}
    Suit (const Diamonds&) : S_ (DIAMONDS) {}
    Suit (const Hearts&)   : S_ (HEARTS)   {}
    Suit (const Spades&)   : S_ (SPADES)   {}

    SUIT_ toEnum () const { return S_; }

    inline friend bool operator== (Suit s, Suit t) { return s.S_ == t.S_; }
    inline friend bool operator!= (Suit s, Suit t) { return ! (s == t); }

  public:
    static Clubs    clubs;
    static Diamonds diamonds;
    static Hearts   hearts;
    static Spades   spades;
  };

  inline std::string toString (Suit s)
  {
    switch (s.toEnum())
      {
      case Suit::CLUBS:    return "Clubs";
      case Suit::DIAMONDS: return "Diamonds";
      case Suit::HEARTS:   return "Hearts";
      case Suit::SPADES:   return "Spades";
      }
    // Smart compiler can tell that switch is exhaustive, and will not
    // give us a warning for failing to return at end of function.
    return ""; // Should not be necessary
  }

  inline std::ostream& operator<< (std::ostream& o, Suit s)
  {
    return o << toString (s);
  }

  inline bool operator< (Suit x, Suit y)
  {
    // Knows about enum order
    return x.toEnum() < y.toEnum();
  }

} // namespace Cards

#endif // Recursive Inclusion Guard
