// Copyright (C) Martin Buchholz 2003

#include <iostream>
#include <cassert>
#include <cstdlib>
#include <string>

using namespace std;

#include "Suit.hpp"
using namespace Cards;

struct ConvertibleFromSuit { ConvertibleFromSuit (Suit) {} };
void f (ConvertibleFromSuit) {}

int
main ()
{
  { Suit s = Suit::spades; assert (s == Suit::spades && s != Suit::clubs); }
  { Suit s (Suit::spades); assert (s == Suit::spades && s != Suit::clubs); }

  {
    Suit s = Suit::spades;
    { Suit t = s; assert (t == s); }
    { Suit t (s); assert (t == s); }
  }

  {
    Suit s = Suit::hearts;
    f (ConvertibleFromSuit (s));
    f (s);
    f (Suit::clubs);
  }

  assert (Suit::clubs.toString()    == "Clubs");
  assert (Suit::diamonds.toString() == "Diamonds");
  assert (Suit::hearts.toString()   == "Hearts");
  assert (Suit::spades.toString()   == "Spades");

  assert (Suit::clubs == Suit::clubs);
  assert (Suit::clubs != Suit::diamonds);

  assert (Suit (Suit::clubs) == Suit (Suit::clubs));
  assert (Suit (Suit::clubs) != Suit (Suit::diamonds));

  assert (Suit::clubs < Suit::diamonds);
  assert (Suit::diamonds < Suit::spades);
  assert (! (Suit::hearts < Suit::diamonds));
  assert (! (Suit::hearts < Suit::hearts));

  // ----------------------------------------------------------------
  //   Suit::spades + 1; // no match for '+' operator

  //   static_cast<int>(Suit::spades); // Invalid static_cast

  // { int x = Suit::clubs; } // cannot convert `const Cards::Suit' to `int'
}
