// Copyright (C) Martin Buchholz 2003

#ifndef _Suit_hpp_INCLUDED
#define _Suit_hpp_INCLUDED

#include <iostream>
#include <string>

namespace Cards
{
  class Suit
  {
  private:
    static inline int nextOrdinal ()
    {
      static int firstOrdinal = 0;
      return firstOrdinal++;
    }

    struct SuitBody
    {
      SuitBody (std::string name, int ordinal)
	: name_ (name), ordinal_ (ordinal) {}
      const std::string name_;
      const int ordinal_;
    };

    const SuitBody *p;

    Suit (std::string name) : p (new SuitBody (name, nextOrdinal())) {}

  public:

    std::string toString () const { return p->name_; }

    friend bool operator< (Suit x, Suit y)
    {
      return x.p->ordinal_ < y.p->ordinal_;
    }

    friend bool operator== (Suit x, Suit y) { return x.p == y.p; }
    friend bool operator!= (Suit x, Suit y) { return ! (x == y); }

    static const Suit clubs;
    static const Suit diamonds;
    static const Suit hearts;
    static const Suit spades;
  };

  inline std::ostream& operator<< (std::ostream& o, Suit s)
  {
    return o << s.toString ();
  }
}

#endif // Recursive Inclusion Guard
