// Copyright (C) Martin Buchholz 2003

#ifndef _Suit_hpp_INCLUDED
#define _Suit_hpp_INCLUDED

#include <iostream>
#include <string>

namespace Cards
{
  class Suit
  {
  public:
    enum private_SUIT_ { CLUBS, DIAMONDS, HEARTS, SPADES };

  private:
    typedef private_SUIT_ SUIT_;
    SUIT_ S_;

    template <SUIT_ S> class Literal;

  public:
    template <SUIT_ S>
    Suit (const Literal<S>&) : S_ (S) {}

    SUIT_ toEnum () const { return S_; }

    inline friend bool operator== (Suit s, Suit t) { return s.S_ == t.S_; }
    inline friend bool operator!= (Suit s, Suit t) { return ! (s == t); }

    static const Literal<CLUBS>    clubs;
    static const Literal<DIAMONDS> diamonds;
    static const Literal<HEARTS>   hearts;
    static const Literal<SPADES>   spades;
  };

  template <Suit::private_SUIT_ S>
  class Suit::Literal : private Suit
  {
  public:
    Suit::private_SUIT_ toEnum () const { return S; }
  private:
    friend class Suit;
    Literal () : Suit (*this) {}
    // Prevent treating literals as objects
    void* operator new (size_t);      // outlawed
    void  operator delete (void*);    // outlawed
    void  operator= (const Literal&); // outlawed
    void* operator& () const;         // outlawed
  };

  inline std::string toString (Suit s)
  {
    switch (s.toEnum())
      {
      case Suit::CLUBS:    return "Clubs";
      case Suit::DIAMONDS: return "Diamonds";
      case Suit::HEARTS:   return "Hearts";
      case Suit::SPADES:   return "Spades";
      }
    // Smart compiler can tell that switch is exhaustive, and will not
    // give us a warning for failing to return at end of function.
    return ""; // Should not be necessary
  }

  inline std::ostream& operator<< (std::ostream& o, Suit s)
  {
    return o << toString (s);
  }

  inline bool operator< (Suit x, Suit y)
  {
    // Knows about enum order
    return x.toEnum() < y.toEnum();
  }

} // namespace Cards

#endif // Recursive Inclusion Guard
