// Copyright (C) Martin Buchholz 2003

#include <iostream>
#include <cassert>
#include <string>
using namespace std;

#include "Suit.hpp"
using namespace Cards;

struct ConvertibleFromSuit { ConvertibleFromSuit (Suit) {} };
void f (ConvertibleFromSuit) {}

int
main ()
{
  { Suit s = Suit::spades; assert (s == Suit::spades && s != Suit::clubs); }
  { Suit s (Suit::spades); assert (s == Suit::spades && s != Suit::clubs); }

  {
    Suit s = Suit::spades;
    { Suit t = s; assert (t == s); }
    { Suit t (s); assert (t == s); }
  }

  {
    Suit s = Suit::hearts;
    f (ConvertibleFromSuit (s));
    f (s);
    f (Suit::clubs);
  }

  {
    Suit s = Suit::diamonds;
    switch (s.toEnum())
      {
      case Suit::DIAMONDS: break;
      case Suit::CLUBS: abort (); break;
      default: abort ();
      }
  }

  assert (toString (Suit::clubs)    == "Clubs");
  assert (toString (Suit::diamonds) == "Diamonds");
  assert (toString (Suit::hearts)   == "Hearts");
  assert (toString (Suit::spades)   == "Spades");

  assert (Suit::clubs == Suit::clubs);
  assert (Suit::clubs != Suit::diamonds);
  assert (Suit::CLUBS == Suit::CLUBS);
  assert (Suit::CLUBS != Suit::DIAMONDS);

  assert (Suit (Suit::clubs) == Suit (Suit::clubs));
  assert (Suit (Suit::clubs) != Suit (Suit::diamonds));

  assert (Suit::clubs < Suit::diamonds);
  assert (Suit::diamonds < Suit::spades);
  assert (! (Suit::hearts < Suit::diamonds));
  assert (! (Suit::hearts < Suit::hearts));

  // ----------------------------------------------------------------
  // We prevent the following from being used in client code
  // { Suit s = Suit::CLUBS; } // Compile Error - illegal conversion

  //   Suit::spades + 1; // no match for '+' operator

  //   static_cast<int>(Suit::spades); // Invalid static_cast

  //   &Suit::clubs; // operator& is private

  // Also, can't take reference because:
  // - Suit::Literal<> is inaccessible, and ...
  // error: implicit conversion to inaccessible base class
  // "Cards::Suit" is not allowed
  // { const Suit& s = Suit::clubs; assert (s == Suit::clubs); }


  // Notice how the following message mentions `Clubs', not `0'.
  // { int x = Suit::clubs; } // cannot convert `const Cards::Suit::Clubs'
}
