// alignof library test suite

// Copyright (C) 2003 Martin Buchholz
//
// Permission to copy, use, sell and distribute this software is granted
// provided this copyright notice appears in all copies.
// Permission to modify the code and to distribute modified code is granted
// provided this copyright notice appears in all copies, and a notice
// that the code was modified is included with the copyright notice.
//
// This software is provided "as is" without express or implied warranty,
// and with no claim as to its suitability for any purpose.
//

#include "alignof.h"
#include "assert.h"
#include "stddef.h"
#include "stdio.h"

typedef struct DI { double d; int i; } DI;
typedef struct DS { double d; } DS;
typedef struct X { int i; char c; } X;

typedef void (*funptr) (void);

int
main (int argc, char *argv[])
{
  printf ("-----------------------------------------------------------\n");
#define PRINT_ALIGNOF(type) \
printf ("ALIGNOF (" #type ") == %d\n", ALIGNOF(type))
  PRINT_ALIGNOF (char);
  PRINT_ALIGNOF (short);
  PRINT_ALIGNOF (int);
  PRINT_ALIGNOF (long);
  PRINT_ALIGNOF (float);
  PRINT_ALIGNOF (double);
  PRINT_ALIGNOF (long double);
  PRINT_ALIGNOF (DI);
  PRINT_ALIGNOF (DS);
  PRINT_ALIGNOF (X);

#define CHECK_ALIGNOF_LE_SIZEOF(type) \
assert (ALIGNOF (type) <= sizeof (type))
  CHECK_ALIGNOF_LE_SIZEOF (char);
  CHECK_ALIGNOF_LE_SIZEOF (short);
  CHECK_ALIGNOF_LE_SIZEOF (int);
  CHECK_ALIGNOF_LE_SIZEOF (long);
  CHECK_ALIGNOF_LE_SIZEOF (float);
  CHECK_ALIGNOF_LE_SIZEOF (double);
  CHECK_ALIGNOF_LE_SIZEOF (long double);
  CHECK_ALIGNOF_LE_SIZEOF (void *);
  CHECK_ALIGNOF_LE_SIZEOF (funptr);
  CHECK_ALIGNOF_LE_SIZEOF (DI);
  CHECK_ALIGNOF_LE_SIZEOF (DS);
  CHECK_ALIGNOF_LE_SIZEOF (X);

#define CHECK_ALIGNOF_DIVIDES_SIZEOF(type) \
assert ((sizeof (type) % ALIGNOF (type)) == 0)
  CHECK_ALIGNOF_DIVIDES_SIZEOF (char);
  CHECK_ALIGNOF_DIVIDES_SIZEOF (short);
  CHECK_ALIGNOF_DIVIDES_SIZEOF (int);
  CHECK_ALIGNOF_DIVIDES_SIZEOF (long);
  CHECK_ALIGNOF_DIVIDES_SIZEOF (float);
  CHECK_ALIGNOF_DIVIDES_SIZEOF (double);
  CHECK_ALIGNOF_DIVIDES_SIZEOF (long double);
  CHECK_ALIGNOF_DIVIDES_SIZEOF (void *);
  CHECK_ALIGNOF_DIVIDES_SIZEOF (funptr);
  CHECK_ALIGNOF_DIVIDES_SIZEOF (DI);
  CHECK_ALIGNOF_DIVIDES_SIZEOF (DS);
  CHECK_ALIGNOF_DIVIDES_SIZEOF (X);

#define CHECK_ALIGN_POD(type) \
assert (sizeof (type) == sizeof (ALIGN_POD_TYPE (type)))
  CHECK_ALIGN_POD (char);
  CHECK_ALIGN_POD (short);
  CHECK_ALIGN_POD (int);
  CHECK_ALIGN_POD (long);
  CHECK_ALIGN_POD (float);
  CHECK_ALIGN_POD (double);
  CHECK_ALIGN_POD (long double);
  CHECK_ALIGN_POD (char *);
  CHECK_ALIGN_POD (long *);
  CHECK_ALIGN_POD (DI);
  CHECK_ALIGN_POD (DS);
  CHECK_ALIGN_POD (X);

  return 0;
}
