/* Copyright (C) Martin Buchholz 2003 */

package martin;

import java.io.*;
import martin.CommandResults;

class StreamAccumulator extends Thread
{
    private final InputStream is_;
    private final StringBuffer buffer_ = new StringBuffer();
    private IOException exception_ = null;

    public String result () throws IOException {
	if (exception_ != null)
	    throw exception_;
	return this.buffer_.toString();
    }

    StreamAccumulator (InputStream is) {
        is_ = is;
    }

    public void run() {
        try {
            InputStreamReader isr = new InputStreamReader(is_);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ( (line = br.readLine()) != null) {
		buffer_.append (line + "\n");
	    }
	} catch (IOException e) {
	    exception_ = e;
	}
    }
}

public class Command
{
    public static CommandResults run (String [] argv)
    {
	String stdout = "";
	String stderr = "";
	int exitVal = 0;
	Exception exception = null;

	try {
	    java.lang.Process proc = Runtime.getRuntime().exec (argv);

	    StreamAccumulator errorAccumulator
		= new StreamAccumulator (proc.getErrorStream());

	    StreamAccumulator outputAccumulator
		= new StreamAccumulator (proc.getInputStream());

	    errorAccumulator.start();
	    outputAccumulator.start();

	    exitVal = proc.waitFor();

	    errorAccumulator.join();
	    outputAccumulator.join();

	    stderr = errorAccumulator.result();
	    stdout = outputAccumulator.result();

	} catch (Exception e) {
	    exception = e;
	} finally {
	    return new CommandResults (argv, stdout, stderr,
				       exitVal, exception);
	}
    }

    private static void debugCommand (String [] argv) {
	Command.run (argv).debugPrint();
    }

    public static void main (String []args) {
	debugCommand (new String [] {"echo", "Hello World"});
	debugCommand (new String [] {"blarfd", "Hello World"});
    }
}
