/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_lispy_hpp_INCLUDED_
#define MObS_lispy_hpp_INCLUDED_

#include "Object.hpp"
#include "Cons.hpp"
#include "NullType.hpp"

namespace MObS
{

  template <typename T1, typename T2>
  inline Object
  cons (T1 o1, T2 o2)
  {
    return Cons (Object (o1), Object (o2));
  }

  inline Object
  list ()
  {
    return nil;
  }

  template <typename T1>
  inline Object
  list (T1 o1)
  {
    return cons (Object (o1), nil);
  }

  template <typename T1, typename T2>
  inline Object
  list (T1 o1, T2 o2)
  {
    return cons (Object (o1), list (o2));
  }

  template <typename T1, typename T2, typename T3>
  inline Object
  list (T1 o1, T2 o2, T3 o3)
  {
    return cons (Object (o1), list (o2, o3));
  }

  template <typename T1, typename T2, typename T3, typename T4>
  inline Object
  list (T1 o1, T2 o2, T3 o3, T4 o4)
  {
    return cons (Object (o1), list (o2, o3, o4));
  }

  template <typename T1, typename T2, typename T3, typename T4,
	    typename T5>
  inline Object
  list (T1 o1, T2 o2, T3 o3, T4 o4, T5 o5)
  {
    return cons (Object (o1), list (o2, o3, o4, o5));
  }

  template <typename T1, typename T2, typename T3, typename T4,
	    typename T5, typename T6>
  inline Object
  list (T1 o1, T2 o2, T3 o3, T4 o4, T5 o5, T6 o6)
  {
    return cons (Object (o1), list (o2, o3, o4, o5, o6));
  }

  template <typename T1, typename T2, typename T3, typename T4,
	    typename T5, typename T6, typename T7>
  inline Object
  list (T1 o1, T2 o2, T3 o3, T4 o4, T5 o5, T6 o6, T7 o7)
  {
    return cons (Object (o1), list (o2, o3, o4, o5, o6, o7));
  }

  template <typename T1, typename T2, typename T3, typename T4,
	    typename T5, typename T6, typename T7, typename T8>
  inline Object
  list (T1 o1, T2 o2, T3 o3, T4 o4, T5 o5, T6 o6, T7 o7, T8 o8)
  {
    return cons (Object (o1), list (o2, o3, o4, o5, o6, o7, o8));
  }
} // namespace MObS

#endif // Recursive Inclusion Guard
