namespace Type {

  template <int v>
  struct Int2Type
  {
    enum { value = v };
  };

  template <typename HEAD, typename TAIL>
  struct Pair
  {
    typedef HEAD head;
    typedef TAIL tail;
  };

  struct Empty {};
  typedef Empty Nil;

  // ----------------------------------------------------------------

#define TYPELIST_1(A)               Type::Pair<A, Type::Nil>
#define TYPELIST_2(A,B)             Type::Pair<A, TYPELIST_1(B)>
#define TYPELIST_3(A,B,C)           Type::Pair<A, TYPELIST_2(B,C)>
#define TYPELIST_4(A,B,C,D)         Type::Pair<A, TYPELIST_3(B,C,D)>
#define TYPELIST_5(A,B,C,D,E)       Type::Pair<A, TYPELIST_4(B,C,D,E)>
#define TYPELIST_6(A,B,C,D,E,F)     Type::Pair<A, TYPELIST_5(B,C,D,E,F)>
#define TYPELIST_7(A,B,C,D,E,F,G)   Type::Pair<A, TYPELIST_6(B,C,D,E,F,G)>
#define TYPELIST_8(A,B,C,D,E,F,G,H) Type::Pair<A, TYPELIST_7(B,C,D,E,F,G,H)>

  // ----------------------------------------------------------------

  template <class T1 = Nil,
	    class T2 = Nil,
	    class T3 = Nil,
	    class T4 = Nil,
	    class T5 = Nil,
	    class T6 = Nil,
	    class T7 = Nil,
	    class T8 = Nil>
  struct List;

  template <>
  struct List<Nil, Nil, Nil, Nil, Nil, Nil, Nil, Nil>
  {
    typedef Nil type;
  };

  template <class T1>
  struct List<T1, Nil, Nil, Nil, Nil, Nil, Nil, Nil>
  {
    typedef Pair<T1, typename List<>::type> type;
  };

  template <class T1, class T2>
  struct List<T1, T2, Nil, Nil, Nil, Nil, Nil, Nil>
  {
    typedef Pair<T1, typename List<T2>::type> type;
  };

  template <class T1, class T2, class T3>
  struct List<T1, T2, T3, Nil, Nil, Nil, Nil, Nil>
  {
    typedef Pair<T1, typename List<T2,T3>::type> type;
  };

  template <class T1, class T2, class T3, class T4>
  struct List<T1, T2, T3, T4, Nil, Nil, Nil, Nil>
  {
    typedef Pair<T1, typename List<T2,T3,T4>::type> type;
  };

#define TYPELIST(x) List<x>::type

} // namespace Type
