/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_String_hpp_INCLUDED_
#define MObS_String_hpp_INCLUDED_

#include <string>
#include <gc_cpp.h>
#include <gc_allocator.h>
#include "Object.hpp"
#include "ISequence.hpp"

namespace MObS
{

  class String;

  template <>
  struct ClassName<String>
  {
    static std::string Name () { return "String"; }
  };

  namespace ObI
  {
    template <>
    class Impl<String> : public ImplBase<String,ISequence>
    {
      friend class MObS::String;
      template <class U, class V> friend class MObS::IsA;
      typedef std::char_traits<char> traits_t;
      typedef gc_allocator<char> alloc_t;
      typedef std::basic_string<char, traits_t, alloc_t> gc_string;
      typedef gc_string our_string;
      //typedef std::string our_string;
    protected:
      our_string s_;
      virtual std::ostream& print (std::ostream& o) const;

      size_t length () { return s_.length(); }

      Impl (std::string s)        : s_ (s.c_str()) {}
      Impl (const char *s)        : s_ (s)         {}
      Impl (size_t count, char c) : s_ (count, c)  {}
    };
  } // namespace ObI

  template <class T> class IsA<T, String>
    : public IsA<T, ISequence>
  {};

  class String : public IsA<String>
  {
  public:
    String (std::string s)        : pimpl_ (new Implementation (s))        {}
    String (const char *s)        : pimpl_ (new Implementation (s))        {}
    String (size_t count, char c) : pimpl_ (new Implementation (count, c)) {}

    std::string value() const { return std::string (pimpl_->s_.c_str()); }
    size_t length () { return pimpl_->length(); }

    MObS_OBJECT_INITIALIZERS (String);

  private:
    Implementation *pimpl_;
  };

  template <class T>
  inline bool stringp (const IsA<T,Object>& ob)
  {
    return ob.template is<String>();
  }

  template <> struct Boxable<const char *> { enum { value = false }; };
  template <> struct Boxable<std::string>  { enum { value = false }; };

  template <> struct Object::DeclareConstructor<const char*> { typedef bool Dummy; };
  template <> struct Object::DeclareConstructor<std::string> { typedef bool Dummy; };

  inline String makeObject (std::string s) { return String (s); }
  inline String makeObject (const char* s) { return String (s); }

} // namespace MObS

#endif // Recursive Inclusion Guard
