/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_Object_hpp_INCLUDED_
#define MObS_Object_hpp_INCLUDED_

#include "config.hpp"
#include <boost/type_traits/conversion_traits.hpp>
#include <gc_cpp.h>
#include "IsA.hpp"
#include "BoxingTraits.hpp"

// Macros are evil, but how else to define the complicated
// constructors for each class?  Constructors cannot be inherited.

#define MObS_OBJECT_INITIALIZERS(classbeingdefined)				\
										\
public:										\
/* Friends */									\
/* We need to give our base classes access! */					\
template <class OSC_ObClass1, class OSC_ObClass2>				\
friend class MObS::IsA;								\
										\
/* Copy constructor cannot be defined by a template! */				\
classbeingdefined (const classbeingdefined& o)					\
 : pimpl_ (pimpl (o))								\
{}										\
										\
/* Implicit statically-checked upcast constructor */				\
template <class OSC_ObClass>							\
classbeingdefined (const IsA<OSC_ObClass,classbeingdefined>& o)			\
  : pimpl_ (pimpl (o))								\
{}										\
										\
/* Explicit runtime-checked downcast constructor */				\
template <typename OSC_ObClass>							\
explicit									\
classbeingdefined (const IsA<OSC_ObClass,IsABase>& o)				\
{										\
  if (typep<classbeingdefined> (o))						\
    pimpl_ = static_cast<Implementation *> (pimpl (o));				\
  else										\
    throw Bad_Dynamic_Cast_To<classbeingdefined> (o);				\
}										\
										\
/* Copy assignment operator cannot be defined by a template! */			\
classbeingdefined& operator=							\
(const classbeingdefined& o)							\
{										\
  pimpl_ = pimpl (o);								\
  return *this;									\
}										\
										\
/* statically-checked upcast assignment */					\
template <class OSC_ObClass>							\
classbeingdefined& operator=							\
(const IsA<OSC_ObClass,classbeingdefined>& o)					\
{										\
  pimpl_ = pimpl (o);								\
  return *this;									\
}										\
										\
/* Boxing constructor from value type - compile-time checked. */		\
template <class OSC_ValueType>							\
/* We use a weird template return type					*/	\
/* (which always just resolves to "classbeingdefined &"!),		*/	\
/* because assignment operators can't have a dummy second argument.	*/	\
										\
/* This alternate, more logical implementation, which should work,	*/	\
/* and does with g++, generates an error with icc:			*/	\
/* typename BoxingTraits<ValueType>::					*/	\
/*   template Identity<Object,ValueType>::type&				*/	\
typename BoxingIdentity<classbeingdefined, OSC_ValueType,			\
			typename BoxingTraits<OSC_ValueType>::DummyType>	\
			::type &						\
operator= (OSC_ValueType val)							\
{										\
  return operator= (Boxed<OSC_ValueType>(val));					\
}										\
										\
/* Boxing assignment from value type - compile-time checked.		*/	\
template <class OSC_ValueType>							\
classbeingdefined (OSC_ValueType o,						\
/* We use a dummy second argument to prevent template instantiation,	*/	\
/* because constuctors don't have a return type.			*/	\
		   typename BoxingTraits<OSC_ValueType>::Dummy = false)		\
  : pimpl_ (pimpl (Boxed<OSC_ValueType>(o)))					\
{}										\
										\
typedef int REQUIRE_SEMICOLON_##classbeingdefined


namespace MObS
{
  class Object;

  template <>
  struct ClassName<Object>
  {
    static std::string Name () { return "Object"; }
  };

  template <class ValueClass> class Boxed;

  namespace ObI
  {
    template <>
    class Impl<Object>
    {
      friend class MObS::Object;
      template <class U, class V> friend class MObS::IsA;
    private:
      Object* operator& () const;
      void operator= (const Impl&);
      Impl (const Impl&);
    protected:
      Impl () {}
      void* operator new (size_t size) { return GC_malloc (size); }
      virtual ~Impl () {}
      virtual const Class& getClass() const = 0;
      virtual std::ostream& print (std::ostream&) const = 0;
    };
  }

  namespace ObI
  {
    template <class ObClass, class ObBase>
    class ImplBase : public Impl<ObBase>
    {
    public:
      virtual const StaticClass<ObClass>& getClass() const
      { return StaticClass<ObClass>::getInstance(); }
    };
  }

  template <class T>
  class IsA<T,Object> : public IsA<T, IsABase>
  {
  private:
    // #### The implementation of typep should probably be moved here.
    template <class, class, bool> friend struct typep_Selector;

    template <class To>
    inline bool dynamic_instanceof () const
    {
      return dynamic_cast<typename To::Implementation *> (pimpl ()) != 0;
    }

  public:

    inline std::ostream& print (std::ostream& o) const
    {
      return impl().print (o);
    }

    inline const Class& getClass() const
    {
      return impl().getClass();
    }

    // Emulation of Java's `instanceof'
    template <class To>
    inline bool instanceof () const
    {
      return typep<To> (Self());
    }

    // Emulation of C#'s `is'
    template <class To>
    inline bool is () const
    {
      return instanceof<To> ();
    }

  protected:

    inline ObI::Impl<T> * pimpl () const
    {
      return Self().pimpl_;
    }

    inline ObI::Impl<T> & impl () const
    {
      return * (pimpl ());
    }

    template <class U>
    static inline typename U::Implementation * pimpl (const IsA<U,IsABase>& ob)
    {
      return static_cast<const U&> (ob).pimpl_;
    }

  };

  class Object : public IsA<Object>
  {
  public:
    // C++ does not have "open classes", but one can implement a limited form
    // Here we allow foreign code to create an Object constructor!
    template <typename T> struct DeclareConstructor;
    template <typename T> explicit inline
    Object (T t, typename DeclareConstructor<T>::Dummy = false)
    { *this = makeObject (t); }

    MObS_OBJECT_INITIALIZERS (Object);

  private:
    Implementation *pimpl_;
  };

} // namespace MObS

#endif // Recursive Inclusion Guard
