/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_Number_hpp_INCLUDED_
#define MObS_Number_hpp_INCLUDED_

#include "Object.hpp"

namespace MObS
{

  class Number;

  template <>
  struct ClassName<Number>
  {
    static std::string Name () { return "Number"; }
  };

  namespace ObI
  {
    template <>
    class Impl<Number> : public Impl<Object>
    {
      friend class Number;
      template <class U, class V> friend class MObS::IsA;
    };
  }

  template <class T>
  class IsA<T, Number> : public IsA<T, Object>
  {};

  class Number : public IsA<Number>
  {
  public:
    // C++ does not have "open classes", but one can implement a limited form
    template <typename T> struct DeclareConstructor;
    template <class T> explicit inline
    Number (T t, typename DeclareConstructor<T>::Dummy = false)
    { *this = makeObject (t); }

    MObS_OBJECT_INITIALIZERS (Number);

  private:
    Implementation *pimpl_;
  };

  template <class T>
  inline bool numberp (const IsA<T,IsABase>& ob)
  {
    return typep<Number> (ob);
  }

  // ----------------------------------------------------------------

  // Overriden by concrete number implementations
  template <typename T>
  struct is_ConcreteNumericObType
  {
    static const bool value = false;
  };
  namespace ObI
  {
    template <typename T> struct Native2Concrete;
    template <typename T> struct Concrete2Native;
  }

#define MObS_DECLARE_ConcreteNumericObType(ObType, NativeType)	\
namespace ObI							\
{								\
  template <> struct Concrete2Native<ObType>			\
  {								\
    typedef NativeType type;					\
  };								\
  template <> struct Native2Concrete<NativeType>		\
  {								\
    typedef ObType type;					\
  };								\
}								\
template <> struct is_ConcreteNumericObType<ObType>		\
{								\
  static const bool value = true;				\
}

} // namespace MObS

#endif // Recursive Inclusion Guard
