/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_NullType_hpp_INCLUDED_
#define MObS_NullType_hpp_INCLUDED_

#include "config.hpp"
#include "Object.hpp"

namespace MObS
{

  class NullType;

  template <>
  struct ClassName<NullType>
  {
    static std::string Name () { return "NullType"; }
  };

  namespace ObI
  {
    template <>
    class Impl<NullType> : public ImplBase<NullType, Object>
    {
      friend class MObS::NullType;
      template <class U, class V> friend class MObS::IsA;
      static const Impl<NullType> null;
    protected:
      Impl () {}
      virtual std::ostream& print (std::ostream& o) const;
    };
  }

  template <class T> class IsA<T, NullType> : public IsA<T, Object> {};

  class NullType : public IsA<NullType>
  {
  public:
    MObS_OBJECT_INITIALIZERS (NullType);

    NullType ()
      // Get the address of null, without Implementation::operator&
      : pimpl_ (const_cast<Implementation *>
		(reinterpret_cast<const Implementation *>
		 (&
		  (reinterpret_cast<const char&>
		   (Implementation::null)))))
    {}

  private:
    Implementation *pimpl_;
  };

  extern const NullType null;
  extern const NullType nil;

  template <class T>
  inline bool nullp (const IsA<T,IsABase>& ob)
  {
    return typep<NullType> (ob);
  }

} // namespace MObS

#endif // Recursive Inclusion Guard
