/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_IsA_hpp_INCLUDED_
#define MObS_IsA_hpp_INCLUDED_

#include "config.hpp"
#include <string>
#include <typeinfo>
#include <boost/type_traits/conversion_traits.hpp>
#include <gc.h>

namespace MObS
{
  template <typename T>
  struct ClassName
  {
    static std::string Name () { return typeid(T).name(); }
  };

  class Class
  {
  public:
    virtual std::string virtual_getName () const = 0;

    inline std::string
    getName () const
    {
      return virtual_getName ();
    }
  };

  template <class T> class StaticClass;

  template <class T>
  class StaticClassBase : public Class
  {
  public:
    virtual std::string
    virtual_getName () const
    {
      return StaticClass<T>::getName();
    }

    static inline std::string
    getName()
    {
      static const std::string name (ClassName<T>::Name());
      return name;
    }

    static const StaticClass<T>&
    getInstance ()
    {
      static StaticClass<T> theClass;
      return theClass;
    }
  };

  template <class T>
  class StaticClass : public StaticClassBase<T> {};

  namespace ObI
  {
    template <class T> class Impl;
  }

  template <class T, class Constraint = T> class IsA;

  class IsABase;

  class IsAFrameworkRoot {};

  template <typename T> struct is_MObSType
  { enum { value = ::boost::is_convertible<T*,IsAFrameworkRoot*>::value }; };

  template <class T>
  class IsA<T,IsABase> : public IsAFrameworkRoot
  {
  public:
    typedef ObI::Impl<T> Implementation;

    const T& Self () const
    {
      return *(static_cast<const T*> (this));
    }

    T& Self ()
    {
      return *(static_cast<T*> (this));
    }

    operator const T& () const
    {
      return Self ();
    }

    operator T& ()
    {
      return Self ();
    }

    const T& operator ~ () const
    {
      return Self ();
    }

    T& operator ~ ()
    {
      return Self ();
    }

    const T* operator -> () const
    {
      return static_cast<const T*> (this);
    }

    T* operator -> ()
    {
      return static_cast<T*> (this);
    }

  protected:
    IsA () {}
    ~IsA () {}
  private:
    IsA& operator= (const IsA&);
  };

  class IsABase : public IsA<IsABase>
  {
  };

} // namespace MObS

#include "ObCast.hpp"

#endif // Recursive Inclusion Guard
