/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_Int_hpp_INCLUDED_
#define MObS_Int_hpp_INCLUDED_

#include "Number.hpp"

namespace MObS
{

  class Int;

  template <>
  struct ClassName<Int>
  {
    static std::string Name () { return "Int"; }
  };

  namespace ObI
  {
    template <>
    class Impl<Int> : public ImplBase<Int,Number>
    {
      friend class MObS::Int;
      template <class U, class V> friend class MObS::IsA;
    private:
      int i_;
    protected:
      Impl (int i) : i_ (i) { }
      virtual std::ostream& print (std::ostream& o) const;
    };
  }

  template <class T> class IsA<T, Int> : public IsA<T, Number>
  {
  };

  class Int : public IsA<Int>
  {
  public:
    int intValue () const { return value(); }
    int value () const { return pimpl_->i_; }
    explicit Int (int i) : pimpl_ (new Implementation (i)) {}

    MObS_OBJECT_INITIALIZERS (Int);

  private:
    Implementation *pimpl_;
  };

  template <class T>
  inline bool intp (const IsA<T,IsABase>& ob)
  {
    return typep<Int> (ob);
  }

  MObS_DECLARE_ConcreteNumericObType (Int, int);

  template <> struct Boxable<int>       { enum { value = false }; };
  template <> struct Boxable<long>      { enum { value = false }; };

  template <> struct Object::DeclareConstructor<int>  { typedef bool Dummy; };
  template <> struct Object::DeclareConstructor<long> { typedef bool Dummy; };

  template <> struct Number::DeclareConstructor<int>  { typedef bool Dummy; };
  template <> struct Number::DeclareConstructor<long> { typedef bool Dummy; };

  inline Int makeObject (int i) { return Int (i); }

} // namespace MObS

#endif // Recursive Inclusion Guard
