/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_ISequence_hpp_INCLUDED_
#define MObS_ISequence_hpp_INCLUDED_

#include "Object.hpp"

namespace MObS
{

  class ISequence;            // C#-like
  typedef ISequence Sequence; // Java-like

  template <>
  struct ClassName<ISequence>
  {
    static std::string Name () { return "ISequence"; }
  };

  namespace ObI
  {
    template <>
    class Impl<ISequence> : public Impl<Object>
    {
      friend class ISequence;
      template <class U, class V> friend class MObS::IsA;
    protected:
      virtual size_t length () = 0;
    };
  }

  template <class T>
  class IsA<T, ISequence> : public IsA<T, Object>
  {};

  class ISequence : public IsA<ISequence>
  {
  public:
    size_t length () { return pimpl_->length(); }

    MObS_OBJECT_INITIALIZERS (ISequence);

  private:
    Implementation *pimpl_;
  };

  template <class T>
  inline bool sequencep (const IsA<T,IsABase>& ob)
  {
    return typep<ISequence> (ob);
  }

  template <class T>
  inline size_t length (const IsA<T,ISequence>& ob)
  {
    return T (ob).length();
  }

  template <class T>
  inline size_t length (const IsA<T,IsABase>& ob)
  {
    return ISequence (ob).length();
  }

} // namespace MObS

#endif // Recursive Inclusion Guard
