/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_IO_hpp_INCLUDED_
#define MObS_IO_hpp_INCLUDED_

#include "IsA.hpp"
#include <iostream>

template <class T>
inline std::ostream&
operator<< (std::ostream& o, const MObS::IsA<T,MObS::IsABase>& ob)
{
  //printf ("operator<< %p\n", ob->pimpl_);
  const T& obj (ob);
#ifdef VERBOSE_IO
  o << "<< ";
  o << "static=" << obj.static_typeof () << " ";
  o << "dynamic=" << obj.pimpl_->TypeName () << " ";
  o << obj.pimpl_ << "\n";
#endif
  return obj.print (o);
}

template <typename T>
inline void println (const T& ob)
{
  std::cout << ob << std::endl;
}

#endif // Recursive Inclusion Guard
