/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_IArray_hpp_INCLUDED_
#define MObS_IArray_hpp_INCLUDED_

#include "Object.hpp"
#include "ISequence.hpp"

namespace MObS
{

  class IArray;

  template <>
  struct ClassName<IArray>
  {
    static std::string Name () { return "IArray"; }
  };

  namespace ObI
  {
    template <>
    class Impl<IArray> : public Impl<ISequence>
    {
      friend class IArray;
      template <class U, class V> friend class MObS::IsA;
    };
  }

  template <class T>
  class IsA<T, IArray> : public IsA<T, ISequence>
  {};

  class IArray : public IsA<IArray>
  {
  public:
    size_t length () { return pimpl_->length(); }

    MObS_OBJECT_INITIALIZERS (IArray);

  private:
    Implementation *pimpl_;
  };

  template <class T>
  inline bool arrayp (const IsA<T,IsABase>& ob)
  {
    return typep<IArray> (ob);
  }

} // namespace MObS

#endif // Recursive Inclusion Guard
