/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_Double_hpp_INCLUDED_
#define MObS_Double_hpp_INCLUDED_

#include <boost/type_traits/arithmetic_traits.hpp>
#include "Number.hpp"

namespace MObS
{
  class Double;

  template <>
  struct ClassName<Double>
  {
    static std::string Name () { return "Double"; }
  };

  namespace ObI
  {
    template <>
    class Impl<Double> : public ImplBase<Double,Number>
    {
      friend class MObS::Double;
      typedef double value_type;
      template <class U, class V> friend class MObS::IsA;
    private:
      value_type value_;
    protected:
      inline value_type value () { return value_; }
      virtual std::ostream& print (std::ostream& o) const;
      Impl (value_type value) : value_ (value) { }
    };
  }

  template <class T>
  class IsA<T, Double> : public IsA<T, Number>
  {
  public:
    inline double doubleValue () const
    {
      return static_cast<double> (impl().value());
    }
  };

  class Double : public IsA<Double>
  {
  public:
    inline double value () const { return pimpl_->value(); }
    explicit inline Double (double d) : pimpl_ (new Implementation (d)) {}

    MObS_OBJECT_INITIALIZERS (Double);

  private:
    Implementation *pimpl_;
  };

  template <class T>
  inline bool doublep (const IsA<T,Object>& ob)
  {
    return ob.template instanceof<Double>();
  }

  MObS_DECLARE_ConcreteNumericObType (Double, double);

  template <> struct Boxable<double> { enum { value = false }; };
  template <> struct Boxable<float>  { enum { value = false }; };

  template <> struct Object::DeclareConstructor<double> { typedef bool Dummy; };
  template <> struct Object::DeclareConstructor<float>  { typedef bool Dummy; };

  template <> inline
  Object::Object (double x, Object::DeclareConstructor<double>::Dummy)
  { *this = Double (x); }

  template <> inline
  Object::Object (float x, Object::DeclareConstructor<float>::Dummy)
  { *this = Double (double (x)); }

  template <> struct Number::DeclareConstructor<double> { typedef bool Dummy; };
  template <> struct Number::DeclareConstructor<float>  { typedef bool Dummy; };

  template <> inline
  Number::Number (double x, Number::DeclareConstructor<double>::Dummy)
  { *this = Double (x); }

  template <> inline
  Number::Number (float x, Number::DeclareConstructor<float>::Dummy)
  { *this = Double (double (x)); }

//   inline Double makeObject (double i) { return Double (i); }

} // namespace MObS

#endif // Recursive Inclusion Guard
