/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_Cons_hpp_INCLUDED_
#define MObS_Cons_hpp_INCLUDED_

#include "Object.hpp"

namespace MObS
{

  class Cons;

  template <>
  struct ClassName<Cons>
  {
    static std::string Name () { return "Cons"; }
  };

  namespace ObI
  {
    template <>
    class Impl<Cons> : public ImplBase<Cons,Object>
    {
      friend class MObS::Cons;
      template <class U, class V> friend class MObS::IsA;
      Object car_;
      Object cdr_;
      inline Object getcar () { return car_; }
      inline Object getcdr () { return cdr_; }
      virtual std::ostream& print (std::ostream& o) const;

      template <typename U, typename V>
      Impl (const U& car, const V& cdr) : car_ (car), cdr_ (cdr) {}
    };
  }

  template <class T>
  class IsA<T, Cons> : public IsA<T, Object>
  {
  public:
    Object car () const { return impl().getcar(); }
    Object cdr () const { return impl().getcdr(); }
  };

  class Cons : public IsA<Cons>
  {
  public:
    template <typename T, typename U>
    Cons (const T& car, const U& cdr)
      : pimpl_ (new Implementation (car, cdr)) {}

    MObS_OBJECT_INITIALIZERS (Cons);

  private:
    Implementation *pimpl_;
  };

  template <class T>
  inline bool consp (const IsA<T,Object>& ob)
  {
    return ob.template instanceof<Cons>();
  }

  // ----------------------------------------------------------------
  // Style 1: "Real" function followed by template forwarding
  // This will avoid code bloat
  inline Object
  car (const Cons& ob)
  {
    return ob.car();
  }

  template <class T>
  inline Object
  car (const IsA<T,Object>& ob)
  {
    return car (Cons (ob));
  }

  // ----------------------------------------------------------------
  // Style 2: Functors
  template <class T>
  inline Object
  cdr (const IsA<T,Object>& ob)
  {
    return Cons (ob).cdr();
  }

  extern struct Consp
  {
    template <class T>
    inline bool operator () (const IsA<T,Object>& ob)
    {
      return typep<Cons> (ob);
    }
  } Consp;

  extern struct Car
  {
    inline Object operator () (Cons ob)
    {
      return ob.car();
    }

    template <class T>
    inline Object operator () (const IsA<T,Object>& ob)
    {
      return Car (Cons (ob));
    }
  } Car;

  extern struct Cdr
  {
    template <class T>
    inline Object operator () (const IsA<T,Object>& ob)
    {
      return Cons (ob).cdr();
    }
  } Cdr;

} // namespace MObS

#endif // Recursive Inclusion Guard
