/* Copyright (C) Martin Buchholz 2003 */

#include "config.hpp"
#include "Cons.hpp"
#include "NullType.hpp"
#include <iostream>
#include "IO.hpp"

namespace MObS
{
  struct Consp Consp;
  struct Car   Car;
  struct Cdr   Cdr;

  namespace ObI
  {
    std::ostream&
    Impl<Cons>::print (std::ostream& o) const
    {
      // The obvious implementation:
      //return o << "(" << car_ << ", " << cdr_ << ")";

      // We prefer Lisp Style printing
      o << "(" << car_;

      Object tail = cdr_;

      while (consp (tail))
	{
	  o << " " << car (tail);
	  tail = cdr (tail);
	}

      if (! nullp (tail))
	o << " . " << tail;

      o << ")";
      return o;
    }
  }
}
