/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_BoxingTraits_hpp_INCLUDED_
#define MObS_BoxingTraits_hpp_INCLUDED_
#include "IsA.hpp"

// Some contortions to define how and when to box foreign types
namespace MObS
{
  template <typename T>
  struct Boxable
  {
    enum { value = ! is_MObSType<T>::value };
  };

  template <typename T, bool boxable = Boxable<T>::value>
  struct BoxingTraits;

  // ----------------------------------------------------------------
  // BoxingIdentity is a helper template to constrain Object
  // constructor template instantiations.
  // See Object.hpp
  template <typename T, typename ValueType, typename DummyType>
  struct BoxingIdentity;

  template <typename T, typename ValueType>
  struct BoxingIdentity<T,ValueType, typename BoxingTraits<ValueType>::DummyType>
  {
    typedef T type;
  };

  // The following causes icc to crash
  //   template <typename T, typename ValueType,
  // 	    typename BoxingTraits<ValueType>::Dummy = false>
  //   struct BoxingIdentity2;

  //   template <typename T, typename ValueType>
  //   struct BoxingIdentity2<T,ValueType>
  //   {
  //     typedef T type;
  //   };

} // namespace MObS

#endif // Recursive Inclusion Guard
