/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_Boxed_hpp_INCLUDED_
#define MObS_Boxed_hpp_INCLUDED_

#include <boost/type_traits/conversion_traits.hpp>
#include "IsA.hpp"
#include "Object.hpp"
#include "BoxingTraits.hpp"

namespace MObS
{
  template <class ValueType> class Boxed;
  //template <class ValueType> struct BoxingTraits;
  //template <class ValueType> struct DefaultBoxingTraits;

  template <class ValueType>
  struct ClassName<Boxed<ValueType> >
  {
    static std::string Name ()
    {
      return std::string ("Boxed<")
	+ std::string (StaticClass<ValueType>::getName())
	+ std::string (">");
    }
  };

  template <typename T>
  struct DefaultBoxingTraits
  {
    typedef bool Dummy;
    typedef Object ObBase;
    struct DummyType {};

    // Should work, and does with g++, but generates an error with icc.
    //template <typename U, typename V> struct Identity;
    //template <typename U> struct Identity<U,T> { typedef U type; };
  };

  template <typename T, bool boxable> struct BoxingTraits;
  template <typename T>
  struct BoxingTraits<T, true>
    : public DefaultBoxingTraits<T>
  {};

  template <class T, class ValueType>
  class IsA<T, Boxed<ValueType> >
    : public IsA<T, typename BoxingTraits<ValueType>::ObBase>
  {};

  namespace ObI
  {
    template <class ValueType> class DefaultImpl;

    template <class ValueType>
    class DefaultImpl<Boxed<ValueType> >
      : public ImplBase<Boxed<ValueType>,
			typename BoxingTraits<ValueType>::ObBase>
    {
      friend class MObS::Boxed<ValueType>;
      template <class U, class V> friend class MObS::IsA;
    private:
      ValueType value_;
    protected:
      inline DefaultImpl (ValueType v) : value_ (v) {}

      inline std::ostream& print (std::ostream& o) const { return o << value_; }

      inline ValueType value () const { return value_; }
    };

    template <class ValueType>
    class Impl<Boxed<ValueType> >
      : public DefaultImpl<Boxed<ValueType> >
    {
    public:
      inline Impl (ValueType v) : DefaultImpl<Boxed<ValueType> > (v) {}
    };
  }

  // ----------------------------------------------------------------

  template <class ValueType>
  class Boxed : public IsA<Boxed<ValueType> >
  {
    typedef ObI::Impl<Boxed<ValueType> > Implementation;

  public:
    Boxed (ValueType val) : pimpl_ (new Implementation (val)) {}

    template <typename T>
    Boxed (const IsA<ValueType,T>& val)
      : pimpl_ (new Implementation (static_cast<const ValueType&> (val))) {}
    //operator ValueType () const { return pimpl_->value(); }

    ValueType value () const { return pimpl_->value(); }

    MObS_OBJECT_INITIALIZERS (Boxed);

  private:
    Implementation *pimpl_;
  };

  template <typename T, class U>
  inline T Unbox (const IsA<U,IsABase>& ob)
  {
    return Boxed<T>(ob).value();
  }

} // namespace MObS

#endif // Recursive Inclusion Guard
