/* Copyright (C) Martin Buchholz 2003 */

#ifndef MObS_Array_hpp_INCLUDED_
#define MObS_Array_hpp_INCLUDED_

#include <typeinfo>

#define GC_OPERATOR_NEW_ARRAY
#include <gc_cpp.h>

#include "Object.hpp"
#include "IArray.hpp"

namespace MObS
{
  template <class T> class Array;

  template <class T>
  struct ClassName<Array<T> >
  {
    static std::string Name ()
    {
      return std::string ("Array<")
	+ std::string (StaticClass<T>::getName())
	+ std::string (">");
    }
  };

  namespace ObI
  {
    template <class T>
    class Impl<Array<T> > : public ImplBase<Array<T>,IArray>
    {
      friend class MObS::Array<T>;
      template <class U, class V> friend class MObS::IsA;

    private:
      size_t size_;
      T* elts_;

    protected:
      inline
      Impl (size_t n, const T& initial_value)
	: size_ (n)
      {
	elts_ = reinterpret_cast<T*> (new (GC) char[sizeof (T) * n]);
	for (T* p = elts_; n--; ++p)
	  new (p) T (initial_value);
      }

      virtual
      ~Impl ()
      {
	/* delete[] elts_; */  // Let GC take care of it
      }

      virtual size_t
      length ()
      {
	return size_;
      }

      virtual std::ostream&
      print (std::ostream& o) const
      {
	o << '[';
	for (size_t i = 0; i < size_; ++i)
	  {
	    o << elts_[i];
	    if (i < size_ - 1) o << ", ";
	  }
	o << ']';
	return o;
      }

    };
  }

  template <class T, typename U> class IsA<T, Array<U> >
    : public IsA<T, IArray> {};

  template <class T>
  class Array : public IsA<Array<T> >
  {
    typedef ObI::Impl<Array<T> > Implementation;

  public:
    /* The following is extremely clever -
       it allows the following to work:
       Array<int>     ai (n);      -- OK, default constructor used
       Array<Object>  ao (n);      -- Compile error, no default constructor
       Array<Object>  ao (n, null) -- OK, initial value provided.  */
    inline Array (size_t n, T initial_value = T())
      : pimpl_ (new Implementation (n, initial_value)) {}

    inline T aref (size_t i) const { return pimpl_->elts_[i]; }
    inline void aset (size_t i, T x) { pimpl_->elts_[i] = x; }

    inline T  operator[] (size_t i) const { return pimpl_->elts_[i]; }
    inline T& operator[] (size_t i)       { return pimpl_->elts_[i]; }

    size_t length () { return pimpl_->length(); }

    MObS_OBJECT_INITIALIZERS (Array);

  private:
    Implementation *pimpl_;
  };

} // namespace MObS

#endif // Recursive Inclusion Guard
